#version 150
#extension GL_EXT_gpu_shader4 : enable
///////////////////////////////////////////////////////////////////////////////////////////////////
// iStripper wrapper for Shadertoy conversions by @Calgon  //
///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Notes
//
// Idea was to create a standard wrapper around Shadertoy code that could be applied to any shader
// sourced from Shadertoy.
// Version number is 150 as standard but where later functions are found this is changed to 330

// Wrapper Follows....
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Declare the missing thingamies that aren't available on VGHD
uniform vec3  iChannelResolution[4];	// BUT WE NEED TO FILL THEM !
uniform float iChannelTime[4];

//#define iResolution u_WindowSize
#define iResolution vec3(u_WindowSize, 0)	// Because Shadertoy iResolution is a vec3
#define iFrame 0


//Slow the time functions down a little as standard
//#define iTime u_Elapsed * .5
float iTime;

#define iGlobalTime u_Elapsed * .5

// Seems the word texture is important and should not be replaced.  Therefore we must replace
// Shadertoy texture0..3 with texture 0..3 further down
uniform sampler2D texture0; //Random Surfaces
uniform sampler2D texture1; //Water
uniform sampler2D texture2; //Random Greys
uniform sampler2D texture3; //More surfaces

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture(sampler,fract(P),Bias);}

#define texture texture2D_Fract	// So whenever Shadertoy says "texture" we run it through this Macro
// Can we do the same for Cubemaps 

#define iChannel0 texture0
#define iChannel1 texture1
#define iChannel2 texture2
#define iChannel3 texture3

// Mouse Simulation from @TheEmu	
#define iMouse vec4(0.)
// Alternative Macro if iMouse is better moving
//#define iMouse AUTO_MOUSE  //vec4(0.0,0.0,0.0,0.0)
// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.
#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
//#define MOUSE_POS vec2((0.25+sin(iTime*MOUSE_SPEED*2))*u_WindowSize/2.0)
//#define MOUSE_POS vec2((sin(iTime*1)*.5*u_WindowSize.x/2.0),1.0*u_WindowSize.y/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
#define MOUSE_PRESS vec2(1.0,1.0)
#define AUTO_MOUSE vec4( MOUSE_POS, MOUSE_PRESS )



vec4 iDate;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Uniforms to control timing of each shader
//uniform float cycle_time;
uniform float bgnum;
uniform float maxbgnum;
//uniform float alpha_off;
//uniform float alpha_on;
//uniform float alpha_always_on;
uniform float scene_duration;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Extract a pixel from texture1 to get the random number
float randNum = texture(texture2, vec2(0.0, 0.0)).r;
float seed_start = 3*randNum-1.5;



///////////////////////////////////////////////////////////////////////////////////////////////////
// Shadertoy Code follows
///////////////////////////////////////////////////////////////////////////////////////////////////

// Sourced from https://www.shadertoy.com/view/ldGcDV

// Code by Flopine
// Thanks to wsmind, leon, lsdlive, XT95 and lamogui for teaching me :) <3


#define STEPS 60.
#define PI 3.141592

vec2 moda (vec2 p, float per)
{
   float a = atan(p.y,p.x);
    float l = length(p);
    a = mod(a-per/2.,per)-per/2.;
    return vec2(cos(a),sin(a))*l;
}

mat2 rot (float a)
{
    float c = cos(a);
    float s = sin(a);
    return mat2(c,s,-s,c);
}

float smin( float a, float b, float k )
{
    float h = clamp( 0.5+0.5*(b-a)/k, 0.0, 1.0 );
    return mix( b, a, h ) - k*h*(1.0-h);
}

void mo(inout vec2 p, vec2 d) 
{
	p.y = abs(p.y) - d.x;
	p.x = abs(p.x) - d.y;
	if (p.y > p.x) p.xy = p.yx;
}

vec3 palette (float t, vec3 a, vec3 b, vec3 c, vec3 d)
{
    return a+b*cos(2.*PI*(c*t+d));
}

float cyl (vec2 p, float r)
{
    return length(p)-r;
}

float sphe (vec3 p, float r)
{
	return length(p)-r;    
}

float petal(vec3 p)
{
    p.xy *= rot(PI);
    p.x += sin(p.y/1.7)*1.8;
  	p.y += 2.;
    return cyl(p.xz,p.y*0.1+0.5);
}

float flower(vec3 p)
{
    p.xz *= rot(PI*2.);
    p.xz = moda(p.xz, (2.*PI)/8.);
    p.x -= 3.;
    return petal(p);
}

float pistil(vec3 p)
{
    float r = 1.3;
    float per = r+5.;
    float c = cyl(p.xz,r/4.+p.y*0.04);
    p.y -= tan(iTime);
    p.y = mod(p.y - per/2.,per)-per/2.;
    return smin(sphe(p,r*0.8),c, 0.8);
}

float gate (vec3 p, float mdl)
{
    mo(p.xy,vec2(mdl));
    mo(p.xz, vec2(mdl/2.));
    return min(flower(p),pistil(p));
}

float fractal (vec3 p, int IM)
{
    float g = gate(p,10.);
    for (int i=0; i<IM; i++)
    {        
        p = abs(p);
        p -= 25.;
        p.xy *= rot(PI/4.);      
        p.xz *= rot(PI/8.);       
        g = min(g,gate(p,10.));
    }
    return g;
}


float sdf (vec3 p, int i)
{
    return fractal(p, i);
}

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = 2.*(fragCoord/iResolution.xy)-1.;
	uv.x *= iResolution.x/iResolution.y;
    
    float sin_per = 15.;
    vec3 p = vec3 (0.001,0.001,-cos((iTime)/9.)*sin_per+sin_per);
    vec3 dir = normalize(vec3(uv,1.));
    float shad = 0.;
    float d = 0.;
    
    for (float i=0.;i<STEPS;i++)
    {
		d = sdf(p, int(i));
        if (d<0.01)
        {
            shad = i/STEPS;
            break;
        }
        p+=d*dir;
    }
    vec3 pal = palette(length(uv),
                      vec3(0.5),
                      vec3(0.5),
                      vec3(0.5,0.5,1.),
                      vec3(0.3,0.9,0.8)
                      );
    
    // Time varying pixel color
    vec3 col = vec3(shad*2.5)*pal;

    // Output to screen
    fragColor = vec4(col,1.0);
}


///////////////////////////////////////////////////////////////////////
// Shadertoy footer wrapper
///////////////////////////////////////////////////////////////////////

void main ( void )
{
	float alpha_on;
	float alpha_off;


	if (bgnum > 0){
		alpha_on  = scene_duration * (bgnum - 1.);
		alpha_off = scene_duration * (bgnum + 0.);
	}
	if (bgnum == 0){
		alpha_on  = scene_duration * (maxbgnum) - 1;
		alpha_off = scene_duration * (maxbgnum) + 1;
	}

	
	
	

	iTime = u_Elapsed * .5;


	if (iTime > 6000.){
		iTime = 6000. * fract(iTime / 6000.);
	}
	float cycle_time = maxbgnum * scene_duration;
	float cycles = (u_Elapsed)/cycle_time;
	float full_cycles = trunc(cycles);
    float part_cycles = u_Elapsed - (full_cycles * cycle_time);
	
	vec4 blank = vec4(0.);
	
	// Run the full program only at the right time..
	if ((part_cycles > alpha_on-1.)&&(part_cycles <= alpha_off+1.)){
		mainImage ( gl_FragColor, gl_FragCoord.xy );
		gl_FragColor.a = 1.0;
	}
	// Otherwise... just blank => massive performance boost
	else{
		gl_FragColor = blank;		
    }
	// Still need to fade it
	gl_FragColor.a = 0.0;
   if (part_cycles > alpha_on-1.){
	if (part_cycles <= alpha_off){
		gl_FragColor.a = 1.;
		if ((alpha_off - part_cycles)<1.){
			gl_FragColor.a = alpha_off - part_cycles;
		}
	}
   }
}


